//  Copyright (C) 2002-2003 Intel Corporation, All Rights Reserved.
//  Permission is hereby granted to merge this program code with 
//  other program material to create a derivative work.  This 
//  derivative work may be distributed in compiled object form only.
//  Any other publication of this program, in any form, without the 
//  explicit permission of the copyright holder is prohibited.
//
//  Send questions and comments to erik.j.johnson@intel.com, 
//  aaron.kunze@intel.com

//-------------------------------------------------------------------
// tx.h - Chapter 5
// Common values and datastructures for the transmit segmentation
// task
//

#ifndef TX_H
#define TX_H


//-------------------------------------------------------------------
// Bit positions within the MSF transmit control CSR
#define TX_EN_SPHY_BITPOS					29
#define TX_ENABLE_BITPOS					10
#define TBUF_ELE_SIZE_0_BITPOS				2
#define TBUF_PARTITION_BITPOS				0


//-------------------------------------------------------------------
// MSF memory map
#define MSF_TX_CONTROL_ADDR					0x4
#define MSF_TX_SEQUENCE_0_ADDR				0x60
#define MSF_TBUF_CONTROL_BASE_ADDR			0x1800
#define MSF_TBUF_BASE_ADDR					0x2000

//-------------------------------------------------------------------
// MicroC data structures
#ifdef MICRO_C

//-------------------------------------------------------------------
// The SPI4 tbuf control words
typedef struct s_spi4_tcw
{
	union
	{
		struct
		{
			unsigned int payload_length : 8,
						 prepend_offset : 3,
						 prepend_length : 5,
						 payload_offset : 3,
						 res1			: 1,
						 skip			: 1,
						 res2			: 1,
						 sop			: 1,
						 eop			: 1,
						 addr			: 8;
		} parts;
		unsigned int whole;
	} control_word;
	unsigned int reserved;
} spi4_tcw_t;

#endif // MICRO_C

#endif //TX_H