//  Copyright (C) 2002-2003 Intel Corporation, All Rights Reserved.
//  Permission is hereby granted to merge this program code with 
//  other program material to create a derivative work.  This 
//  derivative work may be distributed in compiled object form only.
//  Any other publication of this program, in any form, without the 
//  explicit permission of the copyright holder is prohibited.
//
//  Send questions and comments to erik.j.johnson@intel.com, 
//  aaron.kunze@intel.com

//-------------------------------------------------------------------
// spi4_rx.h - Chapter 5
// Reassembles incomming packets from a single port on the
// SPI-4 interface using a single thread
//

#ifndef SPI4_RX_H
#define SPI4_RX_H


// This file contains an implementation of the receive reassembly
// process using a single thread.  Incomming mpackets from a single
// port are assembled into complete packets.  Handles to these 
// packets are then placed on a scratch ring for processing.
//

//-------------------------------------------------------------------
// Include files
#include "rx.h"

//-------------------------------------------------------------------
// spi4_rx_init
//
//    Description:
//       Initialize the appropriate CSRs to receive packets on
//       the SPI4 interface.
//
//    Parameters:
//      Outputs: n/a
//      In/Outs: n/a
//      Inputs: n/a
//      Constants: n/a
//      Labels: n/a
//
//    Side effects: Writes to the MSF receive control and 
//                  port map CSRs
//
//    See also: n/a
//
extern void spi4_rx_init();

//-------------------------------------------------------------------
// spi4_rx
//
//    Description:
//       Reassemble an incomming packet. 
//
//    Parameters:
//      Outputs: None.  Implicitly dlBufHandle
//					    and buffer length will be set
//      In/Outs: n/a
//      Inputs: n/a
//      Constants: n/a
//      Labels: n/a
//
//    Side effects:  
//		This routine requires that packets are arriving on only one 
//      port of the SPI4 interface.  If this is not the case, 
//		mpackets from multiple ports will be intermixed into the 
//		one final packet.
//
//		This routine does not return until a packet is reassembled
//      without error.
//
//    See also: spi4_rx_init()
//
extern void spi4_rx();

#endif // SPI4_RX_H
