//------------------------------------------------------------------------------------
//                                                                      
//                   I N T E L   P R O P R I E T A R Y                   
//                                                                       
//      COPYRIGHT (c)  2001 BY  INTEL  CORPORATION.  ALL RIGHTS          
//      RESERVED.   NO  PART  OF THIS PROGRAM  OR  PUBLICATION  MAY      
//      BE  REPRODUCED,   TRANSMITTED,   TRANSCRIBED,   STORED  IN  A    
//      RETRIEVAL SYSTEM, OR TRANSLATED INTO ANY LANGUAGE OR COMPUTER    
//      LANGUAGE IN ANY FORM OR BY ANY MEANS, ELECTRONIC, MECHANICAL,    
//      MAGNETIC,  OPTICAL,  CHEMICAL, MANUAL, OR OTHERWISE,  WITHOUT    
//      THE PRIOR WRITTEN PERMISSION OF :                                
//                                                                       
//                         INTEL  CORPORATION                            
//                                                                      
//                      2200 MISSION COLLEGE BLVD                        
//                                                                       
//                SANTA  CLARA,  CALIFORNIA  95052-8119                  
//                                                                       
//------------------------------------------------------------------------------------

#ifndef SYSTEM_INIT_UC
#define SYSTEM_INIT_UC

#include <dispatch_loop.uc>

//-------------------------------------------------------------------
// system_init
//
//    Description:
//       Initialize rings and dispatch loop data.
//
//    Parameters:
//      Outputs: n/a
//      In/Outs: n.a
//      Inputs: n/a
//      Constants: n/a
//      Labels: n/a
//
//    Side effects: n/a
//
//    See also: n/a
//
#macro	system_init()
	// init buffer meta data cache to Zero.
	.begin
		.reg zero

		immed32(zero, 0)
		dl_meta_init_cache(
			zero, zero, zero, zero, 
			zero, zero, zero, zero)
		// Some of the meta caches are set before
		// they are used.  To avoid assembler
		// warnings, we use .use
		#if (META_CACHE_SIZE > 0)
			.use dl_meta0
		#endif
		#if (META_CACHE_SIZE > 1)
			.use dl_meta1
		#endif
		#if (META_CACHE_SIZE > 2)
			.use dl_meta2
		#endif
		#if (META_CACHE_SIZE > 3)
			.use dl_meta3
		#endif
		#if (META_CACHE_SIZE > 4)
			.use dl_meta4
		#endif
		#if (META_CACHE_SIZE > 5)
			.use dl_meta5
		#endif
		#if (META_CACHE_SIZE > 6)
			.use dl_meta6
		#endif
		#if (META_CACHE_SIZE > 7)
			.use dl_meta7
		#endif

		// Initialise the free buffer list
		.reg me_num
		immed32(me_num, __UENGINE_ID)
		.if (ctx() == 0 && me_num == 0)
			dl_buf_init()
		.endif
	.end


#endm

#endif	//SYSTEM_INIT_UC