//  Copyright (C) 2002-2003 Intel Corporation, All Rights Reserved.
//  Permission is hereby granted to merge this program code with 
//  other program material to create a derivative work.  This 
//  derivative work may be distributed in compiled object form only.
//  Any other publication of this program, in any form, without the 
//  explicit permission of the copyright holder is prohibited.
//
//  Send questions and comments to erik.j.johnson@intel.com, 
//  aaron.kunze@intel.com

//-------------------------------------------------------------------
// spi4_rx_dl.uc - Chapter 5
// This file contains a dispatch loop which receives packets 
// from a SPI-4 device and places them on a ring to further
// processing
//

//	Include Files
#define		RX_DL
#include	"dl_system.h"
#include	"system_init.uc"
#include	"dispatch_loop.uc"
#include	"spi3_rx.uc"

//-----------------------------------------------------------
// Global variables/Registers
//-----------------------------------------------------------
.reg 	global	dl_buf_handle		
.reg	global	dl_next_block

//-----------------------------------------------------------
// Initialize the blocks
//-----------------------------------------------------------
init#:
	; Initialize the system
	system_init()

	; Initialize the outgoing ring
	dl_sink_init()

	; spi4 rx initialization
	spi3_rx_init()

//-----------------------------------------------------------
// dispatch loop
//-----------------------------------------------------------
.begin
	// Ensure that only one thread is executing this code
	.if (ctx() == 0)
		.set dl_meta1
		.while(1)
			// Reassemble a packet
			spi3_rx()
			
			// Enqueue the packet on the rx to processing 
			dl_sink()
		.endw
	.endif

	nop
	ctx_arb[kill]
	nop
	nop
.end


