//------------------------------------------------------------------------------------
//                                                                      
//                   I N T E L   P R O P R I E T A R Y                   
//                                                                       
//      COPYRIGHT (c)  2001 BY  INTEL  CORPORATION.  ALL RIGHTS          
//      RESERVED.   NO  PART  OF THIS PROGRAM  OR  PUBLICATION  MAY      
//      BE  REPRODUCED,   TRANSMITTED,   TRANSCRIBED,   STORED  IN  A    
//      RETRIEVAL SYSTEM, OR TRANSLATED INTO ANY LANGUAGE OR COMPUTER    
//      LANGUAGE IN ANY FORM OR BY ANY MEANS, ELECTRONIC, MECHANICAL,    
//      MAGNETIC,  OPTICAL,  CHEMICAL, MANUAL, OR OTHERWISE,  WITHOUT    
//      THE PRIOR WRITTEN PERMISSION OF :                                
//                                                                       
//                         INTEL  CORPORATION                            
//                                                                      
//                      2200 MISSION COLLEGE BLVD                        
//                                                                       
//                SANTA  CLARA,  CALIFORNIA  95052-8119                  
//                                                                       
//------------------------------------------------------------------------------------
#ifndef	SYSTEM__H
#define	SYSTEM__H

//-------------------------------------------------------------------
//	System SRAM and SDRAM Memory Related Defines
//-------------------------------------------------------------------

/*	Amount of SRAM space available for (meta data of) packet buffers */
#ifndef MICRO_C
#define_eval	BUF_SRAM_SIZE		(1024 * 10)
#else
#define			BUF_SRAM_SIZE		(1024 * 10)
#endif


/*	Amount of SDRAM space available for Packet buffers. */
#ifndef MICRO_C
#define_eval	BUF_SDRAM_SIZE		(64 * 1024 * 10)
#else
#define			BUF_SDRAM_SIZE		(64 * 1024 * 10)
#endif

/*	Size of Meta Data (Buffer Descriptors) in SRAM. 32 entries per buffer.
 * 	Should be a power of 2.
 */
#define			META_DATA_SIZE		32

/*	Size of packet buffer.  */
#define			BUFFER_SIZE			2048

#ifdef	USE_IMPORT_VAR

.import_var BUF_SRAM_BASE
.import_var DL_REL_BASE
.import_var BUF_FREE_LIST0

#else /* no import vars */
/*	Base address in SRAM for the packet buffers. This is for the meta data (buffer descriptors). */
#define			BUF_SRAM_BASE		0x1000

/*	Base Address in DRAM for the packet buffers. This is for the actual packet data. */
#define			BUF_SDRAM_BASE		0x6000

/* free list id that is stored in meta data */
#define         FREE_LIST_ID                    0x0

/*	BLADE ID */
#define			THIS_BLADE_ID					1

//	SRAM Q-Array entries allocated for buffer free list
#define			BUF_QARRAY_BASE					0
#define			BUF_QARRAY_SIZE					4

#endif /* USE_IMPORT_VAR */


//-------------------------------------------------------------------
// System Scratch Ring Related Defines
//-------------------------------------------------------------------

#define DL_DROP_RING					11

/*	Scratch for communicating between RX and first processing ME */
#define RX_TO_PROCESSING_RING				0
#define RX_TO_PROCESSING_RING_BASE			0x1000
#define RX_TO_PROCESSING_RING_SIZE			128

/*	Scratch for communicating between Processing and Tx */
//#define PROCESSING_TO_TX_RING			1
//#define PROCESSING_TO_TX_RING_BASE		0x2000
//#define PROCESSING_TO_TX_RING_SIZE		128


/*  These defines are used by the individual microcode to identify their scratch rings.
 *	The reason for these defines is to improve the portability of microblocks. User just
 *	has to make changes here and the microblocks will remain untouched.
 * 	For the naming convention, the microblock name goes first, then the _RING_ specifier. 
 *  Following this is the direction indicator. '_OUT' would imply the microblock is writing 
 *	to this scratch ring and '_IN' would imply the microblock is reading from this scratch 
 *	ring. If there is more than one 'IN' or 'OUT' ring the name will have '_<digit>' to 
 *  differentiate the rings.
 */


/*	The Ring on which RX sends out msg to next block */

#define 		RX_RING_OUT						RX_TO_PROCESSING_RING
#define			RX_RING_OUT_BASE				RX_TO_PROCESSING_RING_BASE
#define			RX_RING_OUT_SIZE				RX_TO_PROCESSING_RING_SIZE

/*	The input ring ring on which Processing receives msgs from prev block */
#define			PROCESSING_RING_IN				RX_TO_PROCESSING_RING
#define			PROCESSING_RING_IN_BASE			RX_TO_PROCESSING_RING_BASE
#define			PROCESSING_RING_IN_SIZE			RX_TO_PROCESSING_RING_SIZE

/* The ring on which Processing sends out msg to next block  */
#define			PROCESSING_RING_OUT				PROCESSING_TO_TX_RING
#define			PROCESSING_RING_OUT_BASE		PROCESSING_TO_TX_RING_BASE
#define			PROCESSING_RING_OUT_SIZE		PROCESSING_TO_TX_RING_SIZE

/*	The input ring ring on which Tx receives msgs from prev block */
#define			TX_RING_IN						PROCESSING_TO_TX_RING
#define			TX_RING_IN_BASE					PROCESSING_TO_TX_RING_BASE
#define			TX_RING_IN_SIZE					PROCESSING_TO_TX_RING_SIZE


/****************************************************************
 *	Some System Communication ID's and BlockID's Related Defines
 ****************************************************************
 */


/*	All the IX_* constants should be between 0 and 255 (i.e 1 byte) to enable using
 *	them as immed operands in instructions.
 *
 *	IX_NULL is used to denote a NULL (or empty) packet handle, It should not be zero, 
 *	as it would interfere with ring empty (0) condition.
 *	Note: IX_NULL is too generic a name and may clash with core components code.
 *	So it's marked for deletion.  Start using UC_NULL
 */
#define			IX_EXCEPTION					0x1
#define			IX_DROP							0x2

#define			UC_NULL							0xFF		/* NULL for microcode */
#define			DL_BUF_NULL						UC_NULL 	/* NULL Buffer representation */

#define			BID_NULL						UC_NULL		/* NULL Block ID */
#define			BID_EXCEPTION					0x1			/* Exception Block ID */
#define			BID_DROP						0x2			/* Drop Block ID */


/*	Block IDs for various blocks. Block IDs Start from 0x20. (0 to 0x1f and 0xFF are 
 *	reserved for IX_* )
 */

#define			BID_SPI4_RX						0x23
#define			BID_DL_SINK						0x24
#define			BID_PROCESSING					0x25


/* 	Static Bindings (a.k.a targets) for various microblocks. */
#define			SPI3_RX_NEXT_BLOCK				BID_DL_SINK
#define			COUNT_NEXT_BLOCK				BID_DL_SINK


/****************************************************************
 *	             Some System Signal Related Defines
 ****************************************************************
 */

/*	Signals being a precious resource, we use a single signal for 
 *	inter-thread as well as any other inter-me signalling (init over signal)
 */

#define			COMMON_INTER_THD_ME_SIGNAL		10

/*	We are not able to use a single signal before of limitations in assembler.
 *	until then, we need a separate signal for inter-thread signalling.
 */

#define			INTER_THD_SIGNAL				12

/*	ME_NIT_SIGNAL signal is used to let everyone know that initialisation is over
 *	and all blocks in all MEs can start running. This signal will be typically issued
 *	by the system initialisation code and all other MEs should wait for this signal
 *	before starting to run. 
 */

#define			ME_INIT_SIGNAL					COMMON_INTER_THD_ME_SIGNAL


#endif		// SYSTEM__H