//------------------------------------------------------------------------------------
//                                                                      
//                   I N T E L   P R O P R I E T A R Y                   
//                                                                       
//      COPYRIGHT (c)  2001 BY  INTEL  CORPORATION.  ALL RIGHTS          
//      RESERVED.   NO  PART  OF THIS PROGRAM  OR  PUBLICATION  MAY      
//      BE  REPRODUCED,   TRANSMITTED,   TRANSCRIBED,   STORED  IN  A    
//      RETRIEVAL SYSTEM, OR TRANSLATED INTO ANY LANGUAGE OR COMPUTER    
//      LANGUAGE IN ANY FORM OR BY ANY MEANS, ELECTRONIC, MECHANICAL,    
//      MAGNETIC,  OPTICAL,  CHEMICAL, MANUAL, OR OTHERWISE,  WITHOUT    
//      THE PRIOR WRITTEN PERMISSION OF :                                
//                                                                       
//                         INTEL  CORPORATION                            
//                                                                      
//                      2200 MISSION COLLEGE BLVD                        
//                                                                       
//                SANTA  CLARA,  CALIFORNIA  95052-8119                  
//                                                                       
//------------------------------------------------------------------------------------

#ifndef DL_SOURCE_H
#define DL_SOURCE_H

#include "ixp.h"

#ifdef RX_DL

//-------------------------------------------------------------------
// A signal in the processing task that indicates the processing
// task can begin to dequeue packets
__declspec(remote) SIGNAL rx_ring_ready_sig;

#endif

#ifdef PROCESSING_DL

//-------------------------------------------------------------------
// This signal is sent by the rx pipeline to indicate that
// the processing code can begin to dequeue packets
__declspec(visible) SIGNAL rx_ring_ready_sig;

//-------------------------------------------------------------------
// A signal in the tx task that indicates the tx
// task can begin to dequeue packets
__declspec(remote) SIGNAL tx_ring_ready_sig;

#endif

#ifdef TX_DL

//-------------------------------------------------------------------
// This signal is sent by the processing pipeline to indicate that
// the tx code can begin to dequeue packets
__declspec(visible) SIGNAL tx_ring_ready_sig;

#endif

//-------------------------------------------------------------------
// dl_sink_init
//
//    Description:
//      Initialize the ring between rx and processing, or
//		processing and TX, depending on either
//		RX_TO_PROCESSING or PROCESSING_TO_TX being defined
//
//    Parameters:
//      Outputs: n/a
//      In/Outs: n.a
//      Inputs: n/a
//      Constants: n/a
//      Labels: n/a
//
//    Side effects: n/a
//
//    See also: n/a
//
extern void dl_sink_init();


///////////////////////////////////////////////////////////////////////////////
// dl_sink:
//    Description:
//      Enqueue a packet from RX to processing or from processing
//		to TX, depending on a preprocessor constant of either
//		  RX_TO_PROCESSING or
//		  PROCESSING_TO_TX being defined.
//
//    Parameters:
//      Outputs: n/a
//      In/Outs: n.a
//      Inputs: n/a
//      Constants: n/a
//      Labels: n/a
//
//    Side effects: n/a
//
//    See also: n/a
extern void dl_sink();


//-------------------------------------------------------------------
// dl_source_init
//
//    Description:
//		Wait for the upstream process to signal creation of
// 		the ring
//
//    Parameters:
//      Outputs: n/a
//      In/Outs: n.a
//      Inputs: n/a
//      Constants: n/a
//      Labels: n/a
//
//    Side effects: n/a
//
//    See also: n/a
//
extern void dl_source_init();


///////////////////////////////////////////////////////////////////////////////
// dl_source:
//    Description:
//      Dequeue a packet from either RX to processing, depending on either
//		  RX_TO_PROCESSING or
//		  PROCESSING_TO_TX being defined.
//
//    Parameters:
//      Outputs: n/a
//      In/Outs: n.a
//      Inputs: n/a
//      Constants: n/a
//      Labels: n/a
//
//    Side effects: n/a
//
//    See also: n/a
extern void dl_source();

#endif	// DL_SOURCE_H