// BPF specific counters

// Scratchpad addresses

// Drop/RX count

#ifndef BPF_H
#define BPF_H

#define DROP_COUNT_ADDR 0
#define PKT_COUNT_ADDR 4

#define L2_MCAST_BYTE_COUNT_ADDR 8
#define L2_UCAST_BYTE_COUNT_ADDR 12
#define L2_BCAST_BYTE_COUNT_ADDR 16

#define TCP_BYTE_COUNT_ADDR 20
#define UDP_BYTE_COUNT_ADDR 24
#define ICMP_BYTE_COUNT_ADDR 28
#define IP_OTHER_BYTE_COUNT_ADDR 32

#define TINY_PKT_COUNT_ADDR 36
#define SMALL_PKT_COUNT_ADDR 40
#define MEDIUM_PKT_COUNT_ADDR 44
#define LARGE_PKT_COUNT_ADDR 48

#define TCP1_BYTE_COUNT_ADDR 52
#define TCP2_BYTE_COUNT_ADDR 56
#define TCP_XTRA_BYTE_COUNT_ADDR 60

#define UNUSED_COUNTER 0

#define TCP_PROTO 6
#define UDP_PROTO 17
#define ICMP_PROTO 1

#define TINY_LEN 100
#define SMALL_LEN 500
#define MEDIUM_LEN 1000

#endif

#ifdef COUNT_UC
.import_var TCP1_PORT
.import_var TCP2_PORT
#endif