//  Copyright (C) 2002-2003 Intel Corporation, All Rights Reserved.
//  Permission is hereby granted to merge this program code with 
//  other program material to create a derivative work.  This 
//  derivative work may be distributed in compiled object form only.
//  Any other publication of this program, in any form, without the 
//  explicit permission of the copyright holder is prohibited.
//
//  Send questions and comments to erik.j.johnson@intel.com, 
//  aaron.kunze@intel.com

//-------------------------------------------------------------------
// spi4_tx.h - Chapter 5
// Dequeues packets from processing, then segments them and transmits
// them using a single thread onto a single port
//

#include "tx.h"

//-------------------------------------------------------------------
// spi4_tx_init
//
//    Description:
//       Initialize the appropriate CSRs to transmit packets on
//       the SPI4 interface.
//
//    Parameters:
//      Outputs: n/a
//      In/Outs: n/a
//      Inputs: n/a
//      Constants: n/a
//      Labels: n/a
//
//    Side effects: Writes to the MSF transmit control CSR
//
//    See also: n/a
//
void spi4_tx_init();


//-------------------------------------------------------------------
// spi4_tx
//
//    Description:
//		 Segment and transmit buffers.  This microblock operates
//		 as a context-pipeline and thus never returns
//
//    Parameters:
//      Outputs: n/a
//      In/Outs: n/a
//      Inputs: n/a
//      Constants: n/a
//      Labels: n/a
//
//    Side effects:  
//
//    See also: n/a
//
//
void spi4_tx();
