//  Copyright (C) 2002-2003 Intel Corporation, All Rights Reserved.
//  Permission is hereby granted to merge this program code with 
//  other program material to create a derivative work.  This 
//  derivative work may be distributed in compiled object form only.
//  Any other publication of this program, in any form, without the 
//  explicit permission of the copyright holder is prohibited.
//
//  Send questions and comments to erik.j.johnson@intel.com, 
//  aaron.kunze@intel.com

//-------------------------------------------------------------------
// rx.h - Chapter 5
// Common values and datastructures for the receive reassembly
// task.  Uses dispatcher to send packets to the processing code.
//

#ifndef RX_H
#define RX_H


//-------------------------------------------------------------------
// Bit positions within the MSF receive control CSR
#define RX_EN_SPHY_BITPOS					30
#define RBUF_ELE_SIZE_0_BITPOS				2
#define RBUF_PARTITION_BITPOS				0

//-------------------------------------------------------------------
// Bit positions within the SPHY3 receive status word
#define RSW_SPHY3_CHANNEL_BITPOS			0
#define RSW_SPHY3_ERRORS_BITPOS				13
#define RSW_SPHY3_EOP_BITPOS				14
#define RSW_SPHY3_SOP_BITPOS				15
#define RSW_SPHY3_BYTECOUNT_BITPOS			16
#define RSW_SPHY3_BYTECOUNT_MASK			0xff
#define RSW_SPHY3_ELEMENT_BITPOS			24
#define RSW_SPHY3_ELEMENT_MASK				0x7f

//-------------------------------------------------------------------
// MSF memory map
#define MSF_RX_CONTROL_ADDR					0x0
#define MSF_RX_THREAD_FREELIST_0_ADDR		0x30
#define MSF_RX_PORT_MAP_ADDR				0x40
#define MSF_RBUF_ELEMENT_DONE_ADDR			0x44
#define MSF_RBUF_BASE_ADDR					0x2000


//-------------------------------------------------------------------
// MicroC data structures
#ifdef MICRO_C

//-------------------------------------------------------------------
// The SPI4 receive status words
typedef struct s_spi4_rsw
{
	// The first status word
	union
	{
		struct 
		{
			unsigned int	rprot		: 1,
							element		: 7,
							byte_count	: 8,
							sop			: 1,
							eop			: 1,
							err			: 1,
							len_err		: 1,
							par_err		: 1,
							abort_err	: 1,
							null		: 1,
							type		: 1,
							addr		: 8;

		} parts;
		unsigned int whole;
	} w1;

	// The second status word
	union
	{
		unsigned int whole;
	} w2;
} spi4_rsw_t;

#endif // MICRO_C


#endif // RX_H