//  Copyright (C) 2002-2003 Intel Corporation, All Rights Reserved.
//  Permission is hereby granted to merge this program code with 
//  other program material to create a derivative work.  This 
//  derivative work may be distributed in compiled object form only.
//  Any other publication of this program, in any form, without the 
//  explicit permission of the copyright holder is prohibited.
//
//  Send questions and comments to erik.j.johnson@intel.com, 
//  aaron.kunze@intel.com

//-------------------------------------------------------------------
// spi4_tx_dl.uc - Chapter 5
// This file contains a dispatch loop which receives packets 
// from a the processing ring and transmits them out a SPI-4
// interface
//

//	Include Files
#include	"dl_system.h"
#include	"system_init.uc"
#include	"dispatch_loop.uc"
#include	"spi3_tx.uc"

//-----------------------------------------------------------
// Global variables/Registers
//-----------------------------------------------------------
.reg 	global	dl_buf_handle		

//-----------------------------------------------------------
// Initialize the blocks
//-----------------------------------------------------------
init#:
	; Initialize the system
	system_init()

	; spi4 tx initialization
	spi3_tx_init()

	; Initialize the incoming ring
	dl_source_init()

//-----------------------------------------------------------
// dispatch loop
//-----------------------------------------------------------
.begin
	// Ensure that only one thread is executing this code
	.if (ctx() == 0)
		.set dl_meta1
		// Get, segment and transmit the
		// packet
		spi3_tx()
	.endif

	nop
	ctx_arb[kill]
	nop
	nop
.end


