//------------------------------------------------------------------------------------
//                                                                      
//                   I N T E L   P R O P R I E T A R Y                   
//                                                                       
//      COPYRIGHT (c)  2001 BY  INTEL  CORPORATION.  ALL RIGHTS          
//      RESERVED.   NO  PART  OF THIS PROGRAM  OR  PUBLICATION  MAY      
//      BE  REPRODUCED,   TRANSMITTED,   TRANSCRIBED,   STORED  IN  A    
//      RETRIEVAL SYSTEM, OR TRANSLATED INTO ANY LANGUAGE OR COMPUTER    
//      LANGUAGE IN ANY FORM OR BY ANY MEANS, ELECTRONIC, MECHANICAL,    
//      MAGNETIC,  OPTICAL,  CHEMICAL, MANUAL, OR OTHERWISE,  WITHOUT    
//      THE PRIOR WRITTEN PERMISSION OF :                                
//                                                                       
//                         INTEL  CORPORATION                            
//                                                                      
//                      2200 MISSION COLLEGE BLVD                        
//                                                                       
//                SANTA  CLARA,  CALIFORNIA  95052-8119                  
//                                                                       
//------------------------------------------------------------------------------------

#ifndef DL_SOURCE_UC
#define DL_SOURCE_UC

#include <stdmac.uc>
#include <dispatch_loop.h>
#include <dl_misc.uc>
#include "scratch_rings.uc"
#include "bpf.h"

#ifdef RX_DL

//-------------------------------------------------------------------
// A signal in the processing task that indicates the processing
// task can begin to dequeue packets
.sig remote rx_ring_ready_sig

#endif

#ifdef PROCESSING_DL

//-------------------------------------------------------------------
// This signal is sent by the rx pipeline to indicate that
// the processing code can begin to dequeue packets
.sig visible rx_ring_ready_sig
.addr rx_ring_ready_sig 2

//-------------------------------------------------------------------
// A signal in the tx task that indicates the tx
// task can begin to dequeue packets
.sig remote tx_ring_ready_sig

#endif

#ifdef TX_DL

//-------------------------------------------------------------------
// This signal is sent by the processing pipeline to indicate that
// the tx code can begin to dequeue packets
.sig visible tx_ring_ready_sig
.addr tx_ring_ready_sig 2

#endif

//-------------------------------------------------------------------
// dl_sink_init
//
//    Description:
//      Initialize the ring between rx and processing, or
//		processing and TX, depending on either
//		RX_TO_PROCESSING or PROCESSING_TO_TX being defined
//
//    Parameters:
//      Outputs: n/a
//      In/Outs: n.a
//      Inputs: n/a
//      Constants: n/a
//      Labels: n/a
//
//    Side effects: n/a
//
//    See also: n/a
//
#macro dl_sink_init()
.if (ctx() == 0)

// The sink block code for RX to processing
#ifdef RX_DL
	scratch_ring_init(
		RX_TO_PROCESSING_RING,
		RX_TO_PROCESSING_RING_BASE,
		RX_TO_PROCESSING_RING_SIZE)

	// Send a signal to processing indicating the ring is ready
	.begin
		.reg proc_start
		move(proc_start, 
			 ((RING_CONSUMER_ONE_CTX<<4) |
			 (&remote(rx_ring_ready_sig, 
			 		  RING_CONSUMER_ONE_ME))))
 		alu_shf_left(proc_start, proc_start, OR,
				 	 RING_CONSUMER_ONE_ME, 7) 
		cap[fast_wr, alu, interthread_sig]
		move(proc_start, 
			 ((RING_CONSUMER_TWO_CTX<<4) |
			 (&remote(rx_ring_ready_sig, 
			 		  RING_CONSUMER_TWO_ME))))
 		alu_shf_left(proc_start, proc_start, OR,
				 	 RING_CONSUMER_TWO_ME, 7) 
		cap[fast_wr, alu, interthread_sig]
		move(proc_start, 
			 ((RING_CONSUMER_THREE_CTX<<4) |
			 (&remote(rx_ring_ready_sig, 
			 		  RING_CONSUMER_THREE_ME))))
 		alu_shf_left(proc_start, proc_start, OR,
				 	 RING_CONSUMER_THREE_ME, 7) 
		cap[fast_wr, alu, interthread_sig]
		move(proc_start, 
			 ((RING_CONSUMER_FOUR_CTX<<4) |
			 (&remote(rx_ring_ready_sig, 
			 		  RING_CONSUMER_FOUR_ME))))
 		alu_shf_left(proc_start, proc_start, OR,
				 	 RING_CONSUMER_FOUR_ME, 7) 
		cap[fast_wr, alu, interthread_sig]
		move(proc_start, 
			 ((RING_CONSUMER_FIVE_CTX<<4) |
			 (&remote(rx_ring_ready_sig, 
			 		  RING_CONSUMER_FIVE_ME))))
 		alu_shf_left(proc_start, proc_start, OR,
				 	 RING_CONSUMER_FIVE_ME, 7) 
		cap[fast_wr, alu, interthread_sig]
		move(proc_start, 
			 ((RING_CONSUMER_SIX_CTX<<4) |
			 (&remote(rx_ring_ready_sig, 
			 		  RING_CONSUMER_SIX_ME))))
 		alu_shf_left(proc_start, proc_start, OR,
				 	 RING_CONSUMER_SIX_ME, 7) 
		cap[fast_wr, alu, interthread_sig]
		move(proc_start, 
			 ((RING_CONSUMER_SEVEN_CTX<<4) |
			 (&remote(rx_ring_ready_sig, 
			 		  RING_CONSUMER_SEVEN_ME))))
 		alu_shf_left(proc_start, proc_start, OR,
				 	 RING_CONSUMER_SEVEN_ME, 7) 
		cap[fast_wr, alu, interthread_sig]
		.use proc_start // Suppress an assembler warning
	.end
#endif

// The sink block code for processing to tx
#ifdef PROCESSING_DL
	// *** We don't need any of this
	// Initialize the ring between tx and processing
	//scratch_ring_init(
	//	PROCESSING_TO_TX_RING,
	//	PROCESSING_TO_TX_RING_BASE,
	//	PROCESSING_TO_TX_RING_SIZE)

	// Send a singal to tx indicating the ring is 
	// ready
	//.begin
	//	.reg proc_start
	//	move(proc_start,  
	//		 ((RING_CONSUMER_CTX << 4) |
	//		 (&remote(tx_ring_ready_sig, 
	//		 		  RING_CONSUMER_ME))))
	//	alu_shf_left(proc_start, proc_start, OR,
	//			 	 RING_CONSUMER_ME, 7) 
	//	cap[fast_wr, alu, interthread_sig]
	//	.use proc_start // Suppress a warning
	//.end
#endif

.endif
#endm


///////////////////////////////////////////////////////////////////////////////
// dl_sink:
//    Description:
//      Enqueue a packet from RX to processing or from processing
//		to TX, depending on a preprocessor constant of either
//		  RX_TO_PROCESSING or
//		  PROCESSING_TO_TX being defined.
//
//    Parameters:
//      Outputs: n/a
//      In/Outs: n.a
//      Inputs: n/a
//      Constants: n/a
//      Labels: n/a
//
//    Side effects: n/a
//
//    See also: n/a

#macro dl_sink()
.begin
	.reg buf_length offset

#ifdef RX_DL
#define __DL_SINK_RING		RX_TO_PROCESSING_RING
#endif

#ifdef PROCESSING_DL
#define __DL_SINK_RING		PROCESSING_TO_TX_RING
#endif

	//	In the case of an exception packet, it needs to 
	//  be sent to the core (Xscale)
	//	through a different ring.
	// For now just drop the packet.
	br=byte[dl_next_block, 0, IX_EXCEPTION, drop_packet#]
		
	// Enqueue the packet on the appropriate
	// scratch ring.  First check if the ring 
	// is full, and if so drop the packet.
	scratch_ring_full(
		__DL_SINK_RING, 
		drop_packet#)

	// Enqueue the handle, length and offset
	// of the packet
	dl_meta_get_buffer_size(buf_length)
	dl_meta_get_offset(offset)
	scratch_ring_put_buffer(
		__DL_SINK_RING,
		dl_buf_handle,
		buf_length,
		offset)
	br[done#]

drop_packet#:
	.begin
	.reg addr
	immed[addr, DROP_COUNT_ADDR]
	scratch[incr, --, addr, 0]
	.end
	dl_buf_drop(dl_buf_handle)

done#:
#undef __DL_SINK_RING
.end
#endm


//-------------------------------------------------------------------
// dl_source_init
//
//    Description:
//		Wait for the upstream process to signal creation of
// 		the ring
//
//    Parameters:
//      Outputs: n/a
//      In/Outs: n.a
//      Inputs: n/a
//      Constants: n/a
//      Labels: n/a
//
//    Side effects: n/a
//
//    See also: n/a
//
#macro dl_source_init()
.if (ctx() == 0)
#ifdef PROCESSING_DL

	// Wait for a signal from RX indicating the
	// incoming ring is ready
	ctx_arb[rx_ring_ready_sig]

#endif

#ifdef TX_DL

	// Wait for a signal from processing 
	// indicating the incoming ring is ready
	ctx_arb[tx_ring_ready_sig]

#endif

.endif
#endm

///////////////////////////////////////////////////////////////////////////////
// dl_source:
//    Description:
//      Dequeue a packet from either RX to processing, depending on either
//		  RX_TO_PROCESSING or
//		  PROCESSING_TO_TX being defined.
//
//    Parameters:
//      Outputs: n/a
//      In/Outs: n.a
//      Inputs: n/a
//      Constants: n/a
//      Labels: n/a
//
//    Side effects: n/a
//
//    See also: n/a

#macro dl_source()
.begin
	.reg buf_length offset

#ifdef PROCESSING_DL
#define __DL_SOURCE_RING		RX_TO_PROCESSING_RING
#endif

#ifdef TX_DL
#define __DL_SOURCE_RING		PROCESSING_TO_TX_RING
#endif


	// Dequeue a packet from the appropriate ring
	scratch_ring_get_buffer(
		__DL_SOURCE_RING,
		dl_buf_handle,
		buf_length,
		offset)
					
	// Check for an empty queue
	.if (dl_buf_handle != 0)
		// The queue was not empty
		dl_meta_set_buffer_size(buf_length)
		dl_meta_set_offset(offset)
	.endif

#undef __DL_SOURCE_RING
.end
#endm


#endif	// DL_SOURCE_UC