//  Copyright (C) 2002-2003 Intel Corporation, All Rights Reserved.
//  Permission is hereby granted to merge this program code with 
//  other program material to create a derivative work.  This 
//  derivative work may be distributed in compiled object form only.
//  Any other publication of this program, in any form, without the 
//  explicit permission of the copyright holder is prohibited.
//
//  Send questions and comments to erik.j.johnson@intel.com, 
//  aaron.kunze@intel.com

//-------------------------------------------------------------------
// count_dl.uc - Chapter 5
// This file contains a dispatch loop which dequeues packets from 
// receive, counts them, and enqueues them
// for transmit using a single thread
//

//	Include Files
#define 	PROCESSING_DL
#include	"dl_system.h"
#include	"system_init.uc"
#include	"dispatch_loop.uc"
#include	"count.uc"

//-----------------------------------------------------------
// Global variables/Registers
//-----------------------------------------------------------
.reg 	global	dl_buf_handle		
.reg	global	dl_next_block

//-----------------------------------------------------------
// Initialize the blocks
//-----------------------------------------------------------
init#:
	; Initialize the system
	system_init()
	.use dl_meta0 dl_meta1 dl_meta2 dl_meta3

	; Initialize the outgoing ring
	dl_sink_init()

	; counter initialization
	count_init()

	; Initialize the incoming ring
	dl_source_init()

//-----------------------------------------------------------
// dispatch loop
//-----------------------------------------------------------
.begin
	// Ensure that only one thread is executing this code
	.if (ctx() == 0)
		.set dl_meta1
		.while(1)
			// Dequeue a packet from the rx task
			dl_source()

			.if (dl_buf_handle == 0)
				.continue
			.endif
							
			// Increment the counters
			count()

			// Enqueue the packet on the processing to tx 
			// scratch ring
			//dl_sink()
			dl_buf_drop[dl_buf_handle]
		.endw
	.endif

	nop
	ctx_arb[kill]
	nop
	nop
.end


