//  Copyright (C) 2002-2003 Intel Corporation, All Rights Reserved.
//  Permission is hereby granted to merge this program code with 
//  other program material to create a derivative work.  This 
//  derivative work may be distributed in compiled object form only.
//  Any other publication of this program, in any form, without the 
//  explicit permission of the copyright holder is prohibited.
//
//  Send questions and comments to erik.j.johnson@intel.com, 
//  aaron.kunze@intel.com

//-------------------------------------------------------------------
// count.uc - Chapter 5
//

#ifndef COUNT_UC
#define COUNT_UC


#include "stdmac.uc"
#include "bpf.h"

//-------------------------------------------------------------------
// count_init
//
//    Description:
//       Initialize the packet and byte counters.
//
//    Parameters:
//      Outputs: n/a
//      In/Outs: n/a
//      Inputs: n/a
//      Constants: n/a
//      Labels: n/a
//
//    Side effects: n/a
//
//    See also: n/a
//
#macro count_init()

#endm


//-------------------------------------------------------------------
// count
//
//    Description:
//       Update the packet and byte counters.
//
//    Parameters:
//      Outputs: n/a
//      In/Outs: n/a
//      Inputs: n/a
//      Constants: n/a
//      Labels: n/a
//
//    Side effects: n/a
//
//    See also: n/a
//
#macro count()
.begin
	.reg $buf_length_xfer buf_length
	.reg pkt_addr
	.reg addr
	.sig counter_sig
	
	immed[addr, PKT_COUNT_ADDR]
	scratch[incr, --, addr, 0]

	dl_meta_get_buffer_size(buf_length)
	move($buf_length_xfer, buf_length)

	// Categorize based on packet size
	.if( buf_length <= TINY_LEN )
		immed[addr, TINY_PKT_COUNT_ADDR]
		scratch[incr, --, addr, 0]
	.elif( buf_length <= SMALL_LEN )
		immed[addr, SMALL_PKT_COUNT_ADDR]
		scratch[incr, --, addr, 0]
	.elif( buf_length <= MEDIUM_LEN )
		immed[addr, MEDIUM_PKT_COUNT_ADDR]
		scratch[incr, --, addr, 0]
	.else
		immed[addr, LARGE_PKT_COUNT_ADDR]
		scratch[incr, --, addr, 0]
	.endif

	dl_buf_get_data[addr,dl_buf_handle]
	dl_meta_get_offset[pkt_addr]
	alu[pkt_addr,pkt_addr,+,addr]

	xbuf_alloc[$$hdrs,10,read]
		dram[read,$$hdrs[0],pkt_addr,0,5],
			sig_done[counter_sig]


	/* Layer 2 Counts */
	.begin
	.reg tmp
	alu_shf[tmp, $$hdrs[0],AND,0x01,<<24]
	.if( tmp == 0x01000000 )
		.if( $$hdrs[0] == 0xffffffff )
			alu_shf[tmp,--,B,$$hdrs[1],>>16]
			.if( tmp == 0xffff )
				immed[addr,L2_BCAST_BYTE_COUNT_ADDR]
				scratch[add, $buf_length_xfer, addr, 0],
					ctx_swap[counter_sig]
			.endif
		.else
			immed[addr,L2_MCAST_BYTE_COUNT_ADDR]
			scratch[add, $buf_length_xfer, addr, 0],
				ctx_swap[counter_sig]
		.endif
	.else
		immed[addr,L2_UCAST_BYTE_COUNT_ADDR]
		scratch[add, $buf_length_xfer, addr, 0],
			ctx_swap[counter_sig]
	.endif
	.end
			
	// IP layer processing
	.begin
	.reg tmp
	alu_shf[tmp,--,B,$$hdrs[3],>>16]
	.if( tmp == 0x0800 )
		alu[tmp,$$hdrs[5],AND,0xff]
		.if( tmp == TCP_PROTO )
			immed[addr,TCP_BYTE_COUNT_ADDR]
			scratch[add, $buf_length_xfer, addr, 0],
				ctx_swap[counter_sig]
			alu_shf[tmp,--,B,$$hdrs[9],>>16]
			.if( tmp == TCP1_PORT )
				immed[addr,TCP1_BYTE_COUNT_ADDR]
				scratch[add, $buf_length_xfer, addr, 0],
					ctx_swap[counter_sig]
			.elif( tmp == TCP2_PORT )
				immed[addr,TCP2_BYTE_COUNT_ADDR]
				scratch[add, $buf_length_xfer, addr, 0],
					ctx_swap[counter_sig]
			.else
				immed[addr,TCP_XTRA_BYTE_COUNT_ADDR]
				scratch[add, $buf_length_xfer, addr, 0],
					ctx_swap[counter_sig]
			.endif
		.elif( tmp == UDP_PROTO )
			immed[addr,UDP_BYTE_COUNT_ADDR]
			scratch[add, $buf_length_xfer, addr, 0],
				ctx_swap[counter_sig]
		.elif( tmp == ICMP_PROTO )
			immed[addr,ICMP_BYTE_COUNT_ADDR]
			scratch[add, $buf_length_xfer, addr, 0],
				ctx_swap[counter_sig]
		.else
			immed[addr,IP_OTHER_BYTE_COUNT_ADDR]
			scratch[add, $buf_length_xfer, addr, 0],
				ctx_swap[counter_sig]
		.endif
	.endif
	.end

	xbuf_free[$$hdrs]

//	immed[addr,BYTE_COUNT_ADDR]
//	scratch[add, $buf_length_xfer, addr, 0],
//		ctx_swap[counter_sig]

	immed32(dl_next_block, COUNT_NEXT_BLOCK)
.end
#endm

#endif // COUNT_UC